using System.Web;

namespace RetailCamControlPanel
{
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using RetailCamControlPanel.Services.CompositeService;
    using RetailCamControlPanel.Services.SingularService;
    using RetailCamControlPanel.ViewModel;
    using RetailCamControlPanel.Helper;
    using Models;
    using System.Globalization;
    using System.Collections.Generic;
    using System.Linq;
    //using Resources;
    using System.Configuration;

    /// <summary>
    /// Summary description for Report3.
    /// </summary>
    public partial class CompanyTimeOptimisationReport : Telerik.Reporting.Report
    {
        private String retailCamControlPanelURL = ConfigurationManager.AppSettings["RetailCamControlPanelURL"];


        public CompanyTimeOptimisationReport()
        {
            //
            // Required for telerik Reporting designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        private void CompanyTimeOptimisationReport_NeedDataSource(object sender, EventArgs e)
        {
            //services
            var ffBranchSummaryHourlyReportService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
            var ffBranchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var ffCompositeService = MvcApplication.container.GetInstance<FFCompositeService>();
            var companyServices = MvcApplication.container.GetInstance<CompanyService>();
            var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();
            var ffReportSummaryDailyService = MvcApplication.container.GetInstance<IFFReportSummaryDailyService>();
            var ffCameraService = MvcApplication.container.GetInstance<IFFCameraService>();
            var ffCameraHourlyValueService = MvcApplication.container.GetInstance<IFFCameraHourlyValueService>();
            var ffBranchOperatingHourService = MvcApplication.container.GetInstance<IFFBranchOperatingHourService>();

            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                //Data obtaining - Company name and date for UI
                var startDateUI = Report.Parameters["Date"].Value.ToString();
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();

                DateTime startd = new DateTime();

                if (dateFormatHtml == "dateFirst")
                {
                    startd = DateTime.ParseExact(startDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                }
                else
                {
                    startd = DateTime.ParseExact(startDateUI.ToString(), "MM/dd/yyyy", CultureInfo.InvariantCulture);
                    //dateFormat = 2;
                }

                DayOfWeek dow = startd.DayOfWeek;
                var day = dow.ToString();

                dayDate.Value = CompanyStoreHourReport.CompanyStoreHourReport_Day + ": " + startDateUI + " (" + day + ")";
                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var selectedRegionID = Report.Parameters["Region"].Value.ToString();
                reportTitle.Value = companyName.ToUpper() + ": " + CompanyStoreHourReport.CompanyStoreHourReport_OpeningAndClosingTimeAnalysis.ToUpper();
                var language = Report.Parameters["Language"].Value.ToString();
                string font = Utility.Telerik_GetDefaultFontName();
                var company = companyServices.GetCompany(companyCode);
                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);

                long companyId = 0;
                if (companyCode != "")
                    companyId = companyServices.GetCompany(companyCode).ID;
                else
                    companyId = companySetting.CompanyId;

                DayOfWeek firstDayOfWeek = new DayOfWeek();
                var min = 15;
                var max = 30;
                string[] financialWeek = { "1", "1" };


                //Setting the language
                if (language == "zh-TW" || language == "zh")
                {
                    //To cater for PDF generation
                    font = Utility.Telerik_GetDefaultFontName();

                    //Report Header
                    reportTitle.Style.Font.Name = font;
                    dayDate.Style.Font.Name = font;
                    errorBox.Style.Font.Name = font;
                    Note.Style.Font.Name = font;

                    siteExtendHeader.Style.Font.Name = font;
                    siteReduceHeader.Style.Font.Name = font;
                    expectIncreaseHeader.Style.Font.Name = font;
                    expectSaveHeader.Style.Font.Name = font;

                    siteExtend.Style.Font.Name = font;
                    siteReduce.Style.Font.Name = font;
                    expectIncrease.Style.Font.Name = font;
                    expectSave.Style.Font.Name = font;

                    siteHeader.Style.Font.Name = font;
                    savedHeader.Style.Font.Name = font;
                    extendedHeader.Style.Font.Name = font;
                    expectedFootfallHeader.Style.Font.Name = font;
                    missedOppHeader.Style.Font.Name = font;

                    site.Style.Font.Name = font;
                    expectedSaved.Style.Font.Name = font;
                    extendedHour.Style.Font.Name = font;
                    expectedIncreased.Style.Font.Name = font;

                }

                if (companySetting != null)
                {
                    firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
                        ? DayOfWeek.Sunday
                        : companySetting.FirstDayOfWeek == "Saturday"
                            ? DayOfWeek.Saturday
                            : DayOfWeek.Monday;
                }
                else
                {
                    firstDayOfWeek = DayOfWeek.Monday;
                }


                List<FFBranch> list1 = null;

                //get all branch code in EPOS table
                var branchId = new List<long>();
                var branchCode = new List<string>();
                var branchName = new List<string>();
                var branch = new List<string>();
                var branchTitle = "";

                if (MyHelper.Role == "superadmin")
                {
                    list1 = ffCompositeService.GetAllBranches().ToList();
                    for (int y = 0; y < list1.Count; y++)
                    {
                        var tmpBranchTitle = "";
                        tmpBranchTitle = list1[y].BranchName;
                        if (branchTitle != tmpBranchTitle)
                        {
                            branchTitle = list1[y].BranchName;
                            branchId.Add(list1[y].ID);
                            branchName.Add(list1[y].BranchName);
                            branchCode.Add(list1[y].BranchCode);
                        }
                    }
                }
                else if (MyHelper.Role == "admin" || MyHelper.Role == "reseller")
                {
                    list1 = ffCompositeService.GetAllBranches(MyHelper.CompanyCode).ToList();
                    for (int y = 0; y < list1.Count; y++)
                    {
                        var tmpBranchTitle = "";
                        tmpBranchTitle = list1[y].BranchName;
                        if (branchTitle != tmpBranchTitle)
                        {
                            branchTitle = list1[y].BranchName;
                            branchId.Add(list1[y].ID);
                            branchName.Add(list1[y].BranchName);
                            branchCode.Add(list1[y].BranchCode);
                        }
                    }
                }

                //------------------------------------------
                //define date range
                DateTime firstStartd = startd.AddDays(-28);

                var financialStartEnd = GetFinancialWeekList(startd, companySetting);

                //function to get the date of last year selected week
                var cal = CultureInfo.CurrentCulture.Calendar;
                var lastYearWeekNumber = Utility.GetWeekCount(startd, financialStartEnd.LastYear.FinancialStartDate.Month, financialStartEnd.LastYear.FinancialStartDate.Day, firstDayOfWeek);

                DateTime jan1 = new DateTime(startd.Year - 1, 1, 1);
                int daysOffset = DayOfWeek.Thursday - jan1.DayOfWeek;

                DateTime firstThursday = jan1.AddDays(daysOffset);
                int firstWeek = Utility.GetWeekCount(firstThursday, financialStartEnd.LastYear.FinancialStartDate.Month, financialStartEnd.LastYear.FinancialStartDate.Day, firstDayOfWeek);

                var weekNum = lastYearWeekNumber;
                if (firstWeek <= 1)
                {
                    weekNum -= 1;
                }
                var lastYearresult = firstThursday.AddDays(weekNum * 7);
                var lastYearStart = lastYearresult.AddDays(-3);
                var lastYearEnd = lastYearStart.AddDays(6);


                var regionalSites = new RegionalSiteViewModel();
                var siteInRegionList = new List<long>();
                var getRegionalReport = false;


                //------------------------------------------
                //declare series for different series
                var storeSuggestOpenCloseSeries = new SeriesVM<StoreHourData>();
                storeSuggestOpenCloseSeries.branchId = new List<long>();
                storeSuggestOpenCloseSeries.branchName = new List<string>();
                storeSuggestOpenCloseSeries.data = new List<StoreHourData>();

                var dataForMiniGraph = new CompanyStoreHourViewModel();
                dataForMiniGraph.noOfStoreExtendedHour = new int();
                dataForMiniGraph.noOfStoreReducedHour = new int();
                dataForMiniGraph.expectedIncreaseInFF = new double();
                dataForMiniGraph.expectedSavedLabourHour = new double();

                //------------------------------------------
                //put data into series
                storeSuggestOpenCloseSeries.branchId = branchId;
                storeSuggestOpenCloseSeries.branchName = branchName;

                //only get branches with counters to minimise load time
                for (int i = 0; i < branchId.Count; i++)
                {
                    long bID = branchId[i];
                    var hasCounter = ffCameraService.GetCamera(w => w.BranchId == bID);
                    if (hasCounter == null)
                    {
                        branchId[i] = -1;
                        branchName[i] = "-1";
                    }

                }

                branchId = branchId.Where(w => w != -1).ToList();
                branchName = branchName.Where(w => w != "-1").ToList();
                //only get branches with counters to minimise load time

                var checkNoData = 0;


                for (int branchCount = 0; branchCount < branchId.Count(); branchCount++)
                {
                    var operatingHours = ffBranchOperatingHourService.GetStoreOperatingHour(Convert.ToInt64(Convert.ToDecimal(branchId[branchCount]))).Where(x => x.isDayOff == false && x.Day == (int)dow).ToList();


                    if (operatingHours.Count == 0)
                        checkNoData++;


                }

                if (checkNoData == branchId.Count || branchId.Count() == 0 || financialStartEnd == null)
                {

                    errorBox.Value = "ERR201";

                    errorBox.Visible = true;

                    errorMessage.Visible = true;

                    errorMessage.Value = CompanyStoreHourReport.CompanyStoreHourReport_ReportIsNotAvailable;

                    reportTitle.Visible = false;
                    dayDate.Visible = false;
                    overviewTable.Visible = false;
                    siteTable.Visible = false;
                    table2.Visible = false;
                    Note.Visible = false;
                }


                else
                {
                    errorBox.Visible = false;
                    errorMessage.Visible = false;

                    Note.Value = CompanyStoreHourReport.CompanyStoreHourReport_Note_MissingOpportunityisusedtorepresentextended;

                    siteExtendHeader.Value = CompanyStoreHourReport.CompanyStoreHourReport_Storesforextendedhour;
                    siteReduceHeader.Value = CompanyStoreHourReport.CompanyStoreHourReport_Storesforreducedhour;
                    expectIncreaseHeader.Value = CompanyStoreHourReport.CompanyStoreHourReport_AverageexpectedincreaseinFootfall;
                    expectSaveHeader.Value = CompanyStoreHourReport.CompanyStoreHourReport_Totalexpectedsavedlabourhour;

                    siteHeader.Value = CompanyStoreHourReport.CompanyStoreHourReport_Branch;
                    extendedHeader.Value = CompanyStoreHourReport.CompanyStoreHourReport_SuggestedExtendedHour;
                    expectedFootfallHeader.Value = CompanyStoreHourReport.CompanyStoreHourReport_ExpectedFootfall;
                    savedHeader.Value = CompanyStoreHourReport.CompanyStoreHourReport_ExpectedSavedLabourHour;
                    missedOppHeader.Value = CompanyStoreHourReport.CompanyStoreHourReport_MissedOpportunity;

                    for (int branchCount = 0; branchCount < branchId.Count(); branchCount++)
                    {
                        var pastFourWeeksData = ffReportSummaryDailyService.GetStoreSummaryDaily(branchId[branchCount], firstStartd, startd.AddDays(-7));
                        var hourlyData = ffCameraHourlyValueService.GetStoreSummaryHourly(branchId[branchCount], startd, startd, company, getRegionalReport, siteInRegionList);
                        var thisYearWeekdayData = ffCameraHourlyValueService.GetStoreSummaryHourly(branchId[branchCount], firstStartd, startd.AddDays(-7), true, 0);
                        var thisYearWeekendData = ffCameraHourlyValueService.GetStoreSummaryHourly(branchId[branchCount], firstStartd, startd.AddDays(-7), false, 0);

                        //put value into ValueDateTime
                        for (int i = 0; i < pastFourWeeksData.Count(); i++)
                        {
                            pastFourWeeksData[i].ValueDateTime = Utility.ConvertToDateTime((long)pastFourWeeksData[i].Date);
                        }

                        var thisYearWeekdayOHData = ffCameraHourlyValueService.GetStoreSummaryHourly(branchId[branchCount], firstStartd, startd.AddDays(-7), true, 1);
                        var thisYearWeekendOHData = ffCameraHourlyValueService.GetStoreSummaryHourly(branchId[branchCount], firstStartd, startd.AddDays(-7), false, 1);

                        var thisWeekdayHourlyOHFootfallData = ffCameraHourlyValueService.GetStoreSummaryHourly(branchId[branchCount], startd, startd, true, 1);
                        var thisWeekendHourlyOHFootfallData = ffCameraHourlyValueService.GetStoreSummaryHourly(branchId[branchCount], startd, startd, false, 1);

                        ////group data together for weekday and weekend 
                        var groupWeekdaysHourlyData = ffCameraHourlyValueService.GroupWeekdaysHourlyData(thisYearWeekdayData);
                        var groupWeekEndHourlyData = ffCameraHourlyValueService.GroupWeekEndHourlyData(thisYearWeekendData);

                        //get last year this week data
                        var lastYearData = ffCameraHourlyValueService.GetStoreSummaryHourly(branchId[branchCount], lastYearStart, lastYearEnd, company, getRegionalReport, siteInRegionList);

                        //get operating hour from monday to sunday
                        var storeOperatingHourList = ffBranchOperatingHourService.GetStoreOperatingHour(branchId[branchCount]);
                        //int storeOpeningHour = thisYearWeekdayOHData.Count() != 0 ? thisYearWeekdayOHData.First().ValueDateTime.Hour : 0;
                        int storeOpeningHour = storeOperatingHourList[(int)startd.DayOfWeek].StartTime.Hour;

                        //------------------------------------------
                        //declare series for different series


                        var storeHourTableDataSeries = new StoreHourData();
                        storeHourTableDataSeries.operatingHours = new FFBranchOperatingHourViewModel();
                        storeHourTableDataSeries.outsideTraffic = new List<double>();
                        storeHourTableDataSeries.avgOutsideTraffic = new List<double>();
                        storeHourTableDataSeries.averageOutsideTraffic = new double();
                        storeHourTableDataSeries.averageTurnInRate = new double();
                        storeHourTableDataSeries.missingOpportunity = new List<string>();

                        //------------------------------------------
                        //put data into series



                        storeHourTableDataSeries.operatingHours = storeOperatingHourList.Find(f => f.Day == (int)startd.DayOfWeek);

                        var calcTableData = !storeHourTableDataSeries.operatingHours.isDayOff && thisYearWeekdayOHData.Count() != 0 && thisYearWeekendOHData.Count() != 0 && pastFourWeeksData.Count != 0;

                        //get the average of outside traffic in every hour in everyday from past 4 weeks and last year this week
                        if (calcTableData)
                        {
                            DateTime d = startd;
                            storeHourTableDataSeries.isCounterOn = false;
                            storeHourTableDataSeries.reportDay = (d.ToString("ddd", CultureInfo.InvariantCulture));
                            var TIRtvalue = hourlyData.Where(v => v.ValueDateTime.DayOfWeek == d.DayOfWeek);
                            storeHourTableDataSeries.averageTurnInRate = TIRtvalue.Any() ? TIRtvalue.Average(v => v.TurnInRate) : 0;

                            var hourlyOTData = hourlyData.Where(g => g.ValueDateTime.Date == d.Date).ToList();
                            //check whether if counter online during non operating hour
                            for (int a = 0; a < storeOpeningHour; a++)
                            {
                                if (hourlyOTData[a].OutsideTraffic != 0)
                                {
                                    storeHourTableDataSeries.isCounterOn = true;
                                    break;
                                }
                            }

                            foreach (var data in hourlyOTData)
                            {
                                storeHourTableDataSeries.outsideTraffic.Add(storeHourTableDataSeries.isCounterOn ? data.OutsideTraffic : 0);
                            }

                            if (d.DayOfWeek != DayOfWeek.Saturday && d.DayOfWeek != DayOfWeek.Sunday) //for weekdays
                            {
                                for (int j = 0; j < 24; j++) //for 24 hours
                                {
                                    var tvalue = groupWeekdaysHourlyData.ThisYear.Where(v => v.Date.DayOfWeek == d.DayOfWeek && v.Date.Hour == j);
                                    var lvalue = lastYearData.Where(v => v.ValueDateTime.DayOfWeek == d.DayOfWeek && v.ValueDateTime.Hour == j);
                                    double averagePastFourWeeks = 0;
                                    double totalAverage = 0;
                                    averagePastFourWeeks = tvalue.Any() ? tvalue.Average(v => v.OutsideTraffic) : 0;
                                    totalAverage = (averagePastFourWeeks + (lvalue.Any() ? lvalue.Average(v => v.OutsideTraffic) : 0)) / 2;

                                    storeHourTableDataSeries.avgOutsideTraffic.Add(totalAverage);
                                    storeHourTableDataSeries.averageOutsideTraffic += totalAverage;

                                    var totalFF = thisWeekdayHourlyOHFootfallData.Where(v => v.ValueDateTime.Date == d.Date);
                                    storeHourTableDataSeries.totalFootfallCount = totalFF.Any() ? totalFF.Sum(v => v.ValueIn) : 0;
                                } // end 24 hours loop
                            }
                            else //for weekends
                            {
                                for (int j = 0; j < 24; j++) //for 24 hours
                                {
                                    var tvalue = groupWeekEndHourlyData.ThisYear.Where(v => v.Date.DayOfWeek == d.DayOfWeek && v.Date.Hour == j);
                                    var lvalue = lastYearData.Where(v => v.ValueDateTime.DayOfWeek == d.DayOfWeek && v.ValueDateTime.Hour == j);
                                    double averagePastFourWeeks = 0;
                                    double totalAverage = 0;
                                    averagePastFourWeeks = tvalue.Any() ? tvalue.Average(v => v.OutsideTraffic) : 0;
                                    totalAverage = (averagePastFourWeeks + (lvalue.Any() ? lvalue.Average(v => v.OutsideTraffic) : 0)) / 2;

                                    storeHourTableDataSeries.avgOutsideTraffic.Add(totalAverage);
                                    storeHourTableDataSeries.averageOutsideTraffic += totalAverage;

                                    var totalFF = thisWeekendHourlyOHFootfallData.Where(v => v.ValueDateTime.Date == d.Date);
                                    storeHourTableDataSeries.totalFootfallCount = totalFF.Any() ? totalFF.Sum(v => v.ValueIn) : 0;

                                } // end 24 hours loop
                            }
                            storeHourTableDataSeries.averageOutsideTraffic = storeHourTableDataSeries.averageOutsideTraffic / 24;
                            storeHourTableDataSeries.branchId = branchId[branchCount];
                            storeHourTableDataSeries.branchName = branchName[branchCount];
                            storeSuggestOpenCloseSeries.data.Add(storeHourTableDataSeries);

                            //calculate the suggested opening and closing time, extended hour, expected increase in footfall and expected saved labour hour
                            var storeDataInDay = storeSuggestOpenCloseSeries.data.Last();
                            var avgOutsideTrafficInHour = storeDataInDay.avgOutsideTraffic;
                            var outsideTrafficInHour = storeDataInDay.outsideTraffic;
                            bool isOff = storeDataInDay.operatingHours.isDayOff;
                            storeDataInDay.extendedHour = 0;
                            double totalOTInExtendedHour = 0;
                            if (!isOff && storeDataInDay.isCounterOn)
                            {
                                double openClosevalue = storeDataInDay.averageOutsideTraffic;
                                var actualOpenTime = storeDataInDay.operatingHours.StartTime;
                                var actualCloseTime = storeDataInDay.operatingHours.EndTime;
                                var actualOpenMinute = storeDataInDay.operatingHours.StartTime.Minute == 0 ? "00" : storeDataInDay.operatingHours.StartTime.Minute.ToString();
                                var actualCloseMinute = storeDataInDay.operatingHours.EndTime.Minute == 0 ? "00" : storeDataInDay.operatingHours.EndTime.Minute.ToString();
                                storeDataInDay.currentOpening = actualOpenTime.Hour > 12 ? actualOpenTime.Hour - 12 + ":" + actualOpenMinute + "pm" : actualOpenTime.Hour + ":" + actualOpenMinute + "am";
                                storeDataInDay.currentOpening = actualOpenTime.Hour == 0 ? "12:" + actualOpenMinute + "am" : actualOpenTime.Hour == 12 ? "12:" + actualOpenMinute + "pm" : storeDataInDay.currentOpening;
                                storeDataInDay.currentClosing = actualCloseTime.Hour > 12 ? actualCloseTime.Hour - 12 + ":" + actualCloseMinute + "pm" : actualCloseTime.Hour + ":" + actualCloseMinute + "am";
                                storeDataInDay.currentClosing = actualCloseTime.Hour == 0 ? "12:" + actualCloseMinute + "am" : actualCloseTime.Hour == 12 ? "12:" + actualCloseMinute + "pm" : storeDataInDay.currentClosing;

                                //for missing opportunity
                                for (int a = 6; a < 24; a++) //loop from 6am to 12am
                                {
                                    if (a >= actualOpenTime.Hour && a <= actualCloseTime.Hour)
                                    {
                                        if (a < actualCloseTime.Hour)
                                            storeDataInDay.missingOpportunity.Add("Remain");
                                        else if (actualCloseTime.Minute > 0)
                                            storeDataInDay.missingOpportunity.Add("Remain");
                                        else
                                            storeDataInDay.missingOpportunity.Add("Blank");
                                    }
                                    else
                                        storeDataInDay.missingOpportunity.Add("Blank");
                                }

                                var openTime = 0;
                                var closeTime = 0;
                                double currentExtendedHour = 0;
                                for (int a = 0; a < 24; a++) //check from 0000H
                                {
                                    if (storeDataInDay.suggestedOpening == null && avgOutsideTrafficInHour[a] >= openClosevalue && avgOutsideTrafficInHour[a] != 0)
                                    {
                                        currentExtendedHour = 0;
                                        openTime = a;
                                        if (openTime == actualOpenTime.Hour && actualOpenTime.Minute == 0)
                                        {
                                            storeDataInDay.suggestedOpening = openTime > 12 ? openTime - 12 + ":00pm" + " (" + CompanyStoreHourReport.CompanyStoreHourReport_Remain + ")" : openTime + ":00am" + " (" + CompanyStoreHourReport.CompanyStoreHourReport_Remain + ")";
                                            storeDataInDay.suggestedOpening = a == 0 ? "12:00am (" + CompanyStoreHourReport.CompanyStoreHourReport_Remain + ")" : a == 12 ? "12:00pm (" + CompanyStoreHourReport.CompanyStoreHourReport_Remain + ")" : storeDataInDay.suggestedOpening;
                                        }
                                        else
                                        {
                                            storeDataInDay.suggestedOpening = openTime > 12 ? openTime - 12 + ":00pm" : openTime + ":00am";
                                            storeDataInDay.suggestedOpening = a == 0 ? "12:00am" : a == 12 ? "12:00pm" : storeDataInDay.suggestedOpening;
                                            double openTimeMinutesInHour = actualOpenTime.Minute > 0 ? Convert.ToDouble(actualOpenTime.Minute) / 60 : 0; //if actual opening time not in an exact hour format
                                            currentExtendedHour = (Convert.ToDouble(actualOpenTime.Hour) + openTimeMinutesInHour) - Convert.ToDouble(openTime);
                                            storeDataInDay.extendedHour += currentExtendedHour;
                                            double extraOutsideTraffic = openTimeMinutesInHour * outsideTrafficInHour[actualOpenTime.Hour];
                                            totalOTInExtendedHour = currentExtendedHour > 0 ? (outsideTrafficInHour[openTime] + extraOutsideTraffic) : totalOTInExtendedHour;
                                            if (currentExtendedHour < 0)
                                            {
                                                var indexActualOpen = storeDataInDay.missingOpportunity.FindIndex(v => v == "Remain");
                                                for (int count = 0; count < Math.Ceiling(currentExtendedHour * -1); count++)
                                                {
                                                    storeDataInDay.missingOpportunity[indexActualOpen] = "Reduced";
                                                    indexActualOpen++;
                                                }
                                            }
                                            else if (currentExtendedHour > 0)
                                            {
                                                var isTimeHasMinute = currentExtendedHour - Math.Floor(currentExtendedHour) != 0 ? true : false;
                                                int indexActualOpen = 0;
                                                if (isTimeHasMinute)
                                                    indexActualOpen = storeDataInDay.missingOpportunity.FindIndex(v => v == "Remain");
                                                else
                                                    indexActualOpen = (storeDataInDay.missingOpportunity.FindIndex(v => v == "Remain")) - 1;

                                                for (int count = 0; count < Math.Ceiling(currentExtendedHour); count++)
                                                {
                                                    storeDataInDay.missingOpportunity[indexActualOpen] = "Extended";
                                                    indexActualOpen--;
                                                    if (indexActualOpen < 0)
                                                        break;
                                                }
                                            }

                                        }
                                    }
                                    else if (storeDataInDay.suggestedOpening != null && currentExtendedHour > 0 && a < actualOpenTime.Hour)
                                    {
                                        totalOTInExtendedHour += outsideTrafficInHour[a];
                                    }
                                    else if (storeDataInDay.suggestedOpening != null)
                                    {
                                        break;
                                    }

                                }
                                for (int b = 23; b >= 0; b--) //check from 2300H
                                {
                                    if (storeDataInDay.suggestedClosing == null && avgOutsideTrafficInHour[b] >= openClosevalue)
                                    {
                                        currentExtendedHour = 0;
                                        closeTime = b + 1;
                                        if (closeTime == actualCloseTime.Hour && actualCloseTime.Minute == 0)
                                        {
                                            storeDataInDay.suggestedClosing = closeTime > 12 ? closeTime - 12 + ":00pm" + " (" + CompanyStoreHourReport.CompanyStoreHourReport_Remain + ")" : closeTime + ":00am" + " (" + CompanyStoreHourReport.CompanyStoreHourReport_Remain + ")";
                                            storeDataInDay.suggestedClosing = b + 1 == 24 ? "12:00am (" + CompanyStoreHourReport.CompanyStoreHourReport_Remain + ")" : b + 1 == 12 ? "12:00pm (" + CompanyStoreHourReport.CompanyStoreHourReport_Remain + ")" : storeDataInDay.suggestedClosing;
                                        }
                                        else
                                        {
                                            var checkDiffer = closeTime - actualCloseTime.Hour;
                                            checkDiffer = checkDiffer < 0 ? checkDiffer * -1 : checkDiffer;
                                            if (checkDiffer >= 5)
                                            {
                                                continue;
                                            }
                                            else
                                            {
                                                storeDataInDay.suggestedClosing = closeTime > 12 ? closeTime == 0 ? "12:00am" : closeTime - 12 + ":00pm" : closeTime + ":00am";
                                                double closeTimeMinutesInHour = actualCloseTime.Minute > 0 ? Convert.ToDouble(actualCloseTime.Minute) / 60 : 0; //if actual closing time not in an exact hour format
                                                currentExtendedHour = Convert.ToDouble(closeTime) - (Convert.ToDouble(actualCloseTime.Hour) + closeTimeMinutesInHour);
                                                storeDataInDay.extendedHour += currentExtendedHour;
                                                double extraOutsideTraffic = closeTimeMinutesInHour * outsideTrafficInHour[actualCloseTime.Hour];
                                                totalOTInExtendedHour = currentExtendedHour > 0 ? closeTime != 24 ? totalOTInExtendedHour + outsideTrafficInHour[closeTime] + extraOutsideTraffic : totalOTInExtendedHour + extraOutsideTraffic : totalOTInExtendedHour;
                                                if (currentExtendedHour < 0)
                                                {
                                                    var indexActualClose = storeDataInDay.missingOpportunity.FindLastIndex(v => v == "Remain");
                                                    for (int count = 0; count < Math.Ceiling(currentExtendedHour * -1); count++)
                                                    {
                                                        storeDataInDay.missingOpportunity[indexActualClose] = "Reduced";
                                                        indexActualClose--;
                                                    }
                                                }
                                                else if (currentExtendedHour > 0)
                                                {
                                                    var isTimeHasMinute = currentExtendedHour - Math.Floor(currentExtendedHour) != 0 ? true : false;
                                                    int indexActualClose = 0;
                                                    if (isTimeHasMinute)
                                                        indexActualClose = storeDataInDay.missingOpportunity.FindLastIndex(v => v == "Remain");
                                                    else
                                                        indexActualClose = (storeDataInDay.missingOpportunity.FindLastIndex(v => v == "Remain")) + 1;

                                                    for (int count = 0; count < Math.Ceiling(currentExtendedHour); count++)
                                                    {
                                                        storeDataInDay.missingOpportunity[indexActualClose] = "Extended";
                                                        indexActualClose++;
                                                        if (indexActualClose > 23)
                                                            break;
                                                    }
                                                }

                                            }
                                        }
                                    }
                                    else if (storeDataInDay.suggestedClosing != null && currentExtendedHour > 0 && b > actualCloseTime.Hour)
                                    {
                                        totalOTInExtendedHour += outsideTrafficInHour[b];

                                    }
                                    else if (storeDataInDay.suggestedClosing != null)
                                    {
                                        break;
                                    }
                                }


                                if (storeDataInDay.extendedHour > 0)
                                {
                                    var footfallInExtendedHour = totalOTInExtendedHour * storeDataInDay.averageTurnInRate / 100;
                                    storeDataInDay.expectedIncreaseInFF = storeDataInDay.totalFootfallCount != 0 ? Math.Round((footfallInExtendedHour / storeDataInDay.totalFootfallCount * 100), 2) : 0;
                                    storeDataInDay.expectedSavedLabourHour = 0;
                                    dataForMiniGraph.noOfStoreExtendedHour++;
                                    dataForMiniGraph.expectedIncreaseInFF += storeDataInDay.expectedIncreaseInFF;
                                }
                                else if (storeDataInDay.extendedHour < 0)
                                {
                                    storeDataInDay.expectedIncreaseInFF = 0;
                                    storeDataInDay.expectedSavedLabourHour = storeDataInDay.extendedHour * -1;
                                    dataForMiniGraph.noOfStoreReducedHour++;
                                    dataForMiniGraph.expectedSavedLabourHour += storeDataInDay.expectedSavedLabourHour;
                                }
                                else
                                {
                                    storeDataInDay.expectedIncreaseInFF = 0;
                                    storeDataInDay.expectedSavedLabourHour = 0;
                                }

                            }
                            else if (isOff)
                            {
                                storeDataInDay.currentOpening = CompanyStoreHourReport.CompanyStoreHourReport_OffDay;
                                storeDataInDay.currentClosing = CompanyStoreHourReport.CompanyStoreHourReport_OffDay;
                                storeDataInDay.suggestedOpening = CompanyStoreHourReport.CompanyStoreHourReport_OffDay;
                                storeDataInDay.suggestedClosing = CompanyStoreHourReport.CompanyStoreHourReport_OffDay;
                                storeDataInDay.extendedHour = 0;
                                storeDataInDay.expectedIncreaseInFF = 0;
                                storeDataInDay.expectedSavedLabourHour = 0;
                            }
                            else
                            {
                                storeSuggestOpenCloseSeries.data.Remove(storeSuggestOpenCloseSeries.data.Last());
                            }
                        }

                    }
                    dataForMiniGraph.expectedIncreaseInFF = dataForMiniGraph.noOfStoreExtendedHour != 0 ? dataForMiniGraph.expectedIncreaseInFF / dataForMiniGraph.noOfStoreExtendedHour : 0;

                    overviewTable.DataSource = dataForMiniGraph;

                    siteTable.DataSource = storeSuggestOpenCloseSeries.data;

                    if (storeSuggestOpenCloseSeries.data.Count == 0)
                    {
                        errorBox.Value = "ERR201";

                        errorBox.Visible = true;

                        errorMessage.Visible = true;

                        errorMessage.Value = CompanyStoreHourReport.CompanyStoreHourReport_ReportIsNotAvailable;

                        reportTitle.Visible = false;
                        dayDate.Visible = false;
                        overviewTable.Visible = false;
                        siteTable.Visible = false;
                        table2.Visible = false;
                        Note.Visible = false;
                    }
                }
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }

        


        public FinancialYearVM GetFinancialWeekList(DateTime passedDateTime, CompanySetting companySetting)
        {
            //temporary
            //passedDateTime = new DateTime(2013, 7, 18);

            var fvm = new FinancialYearVM();
            string[] financialWeek = { "1", "1" };
            DayOfWeek firstDayOfWeek = new DayOfWeek();
            if (companySetting.FinancialWeekDate != null)
                financialWeek = new string[] { companySetting.FinancialWeekDate };
            firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday" ? DayOfWeek.Sunday : companySetting.FirstDayOfWeek == "Saturday" ? DayOfWeek.Saturday : companySetting.FirstDayOfWeek == "Friday" ? DayOfWeek.Friday : DayOfWeek.Monday;

            DateTime startd = passedDateTime;
            DateTime thisYearCompanyFinancialWeekStart = new DateTime();
            DateTime thisYearCompanyFinancialWeekEnd = new DateTime();

            DateTime lastYearCompanyFinancialWeekStart = new DateTime();
            DateTime lastYearCompanyFinancialWeekEnd = new DateTime(1);

            //default financial date
            DateTime setCompanyFinancialStartDate = companySetting.DateFormat == "dateFirst" ?
                DateTime.ParseExact(companySetting.FinancialWeekDate, "dd/MM/yyyy", CultureInfo.InvariantCulture) :
                DateTime.ParseExact(companySetting.FinancialWeekDate, "MM/dd/yyyy", CultureInfo.InvariantCulture);
            DateTime setCompanyFinancialEndDate = Utility.GetFinancialYearEndDate(setCompanyFinancialStartDate, firstDayOfWeek);

            thisYearCompanyFinancialWeekStart = setCompanyFinancialEndDate.AddDays(1);
            thisYearCompanyFinancialWeekEnd = Utility.GetFinancialYearEndDate(thisYearCompanyFinancialWeekStart, firstDayOfWeek);

            lastYearCompanyFinancialWeekStart = setCompanyFinancialStartDate;
            lastYearCompanyFinancialWeekEnd = setCompanyFinancialEndDate;

            var tmpLastYear = new FinancialStartEnd();
            tmpLastYear.FinancialStartDate = lastYearCompanyFinancialWeekStart;
            tmpLastYear.FinancialEndDate = lastYearCompanyFinancialWeekEnd;

            var tmpThisYear = new FinancialStartEnd();
            tmpThisYear.FinancialStartDate = thisYearCompanyFinancialWeekStart;
            tmpThisYear.FinancialEndDate = thisYearCompanyFinancialWeekEnd;

            fvm.LastYear = tmpLastYear;
            fvm.ThisYear = tmpThisYear;
            //default financial date


            //do checking to see if passedDate is inside the range of this year financial period
            if (passedDateTime >= fvm.ThisYear.FinancialStartDate && passedDateTime <= fvm.ThisYear.FinancialEndDate)
            {

            }
            //if false
            else
            {
                //calculate the difference of the passedDate with fvm this year startDate
                //fiscal year smaller than default one
                Double differenceInYear = new Double();
                if (passedDateTime < thisYearCompanyFinancialWeekStart)
                {
                    differenceInYear = (double)(Convert.ToDecimal((thisYearCompanyFinancialWeekStart - passedDateTime).TotalDays) / 365.25m);
                    DateTime tmpLastStart = new DateTime();
                    DateTime tmpLastEnd = new DateTime();
                    DateTime tmpThisStart = thisYearCompanyFinancialWeekStart;
                    DateTime tmpThisEnd = new DateTime();
                    for (var i = 0.0; i < differenceInYear; i++)
                    {
                        tmpThisEnd = tmpThisStart.AddDays(-1);
                        tmpThisStart = tmpThisEnd.AddMonths(-12).AddDays(1);

                        var tmpDtDayOfWeek = (int)tmpThisStart.DayOfWeek == 0 ? 0 : (int)tmpThisStart.DayOfWeek;
                        var tmpFirstDayOfWeek = firstDayOfWeek == DayOfWeek.Sunday ? 7 : (int)firstDayOfWeek;
                        int dif = tmpFirstDayOfWeek - tmpDtDayOfWeek;

                        tmpThisStart = tmpThisStart.AddDays(dif);
                        if (dif < 0)
                            dif = dif * -1;
                        if (dif >= 4)
                        {
                            tmpThisStart = tmpThisStart.AddDays(-7);
                        }
                    }
                    //tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);


                    tmpLastEnd = tmpThisStart.AddDays(-1);
                    tmpLastStart = tmpLastEnd.AddMonths(-12).AddDays(1);

                    var tmpDtDayOfWeek2 = (int)tmpLastStart.DayOfWeek == 0 ? 0 : (int)tmpLastStart.DayOfWeek;
                    var tmpFirstDayOfWeek2 = firstDayOfWeek == DayOfWeek.Sunday ? 7 : (int)firstDayOfWeek;
                    int dif2 = tmpFirstDayOfWeek2 - tmpDtDayOfWeek2;

                    tmpLastStart = tmpLastStart.AddDays(dif2);
                    if (dif2 < 0)
                        dif2 = dif2 * -1;
                    if (dif2 >= 4)
                    {
                        tmpLastStart = tmpLastStart.AddDays(-7);
                    }
                    //int pushLastWeekStartToFirstDay = (int)firstDayOfWeek - (int)tmpLastStart.DayOfWeek;
                    //tmpLastStart = tmpLastStart.AddDays(pushLastWeekStartToFirstDay);

                    //if ((int)firstDayOfWeek >= 4 && (int)firstDayOfWeek != 7)
                    //{
                    //    tmpLastStart = tmpLastStart.AddDays(-7);
                    //}

                    tmpLastYear.FinancialStartDate = tmpLastStart;
                    tmpLastYear.FinancialEndDate = tmpLastEnd;

                    tmpThisYear.FinancialStartDate = tmpThisStart;
                    tmpThisYear.FinancialEndDate = tmpThisEnd;

                    fvm.LastYear = tmpLastYear;
                    fvm.ThisYear = tmpThisYear;

                    return fvm;
                }

                //fiscal year greater than default one
                else if (passedDateTime > thisYearCompanyFinancialWeekEnd)
                {
                    differenceInYear = (double)(Convert.ToDecimal((passedDateTime - thisYearCompanyFinancialWeekStart).TotalDays) / 365.25m);
                    DateTime tmpLastStart = new DateTime();
                    DateTime tmpLastEnd = new DateTime();
                    DateTime tmpThisStart = thisYearCompanyFinancialWeekEnd.AddDays(1);
                    DateTime tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);
                    for (var i = 0.0; i < differenceInYear - 1; i++)
                    {
                        if (i > 0)
                        {
                            tmpThisStart = tmpThisEnd.AddDays(1);
                            tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);
                        }
                    }

                    tmpLastEnd = tmpThisStart.AddDays(-1);
                    tmpLastStart = tmpLastEnd.AddMonths(-12);
                    int pushLastWeekStartToFirstDay = (int)firstDayOfWeek - (int)tmpLastStart.DayOfWeek;
                    tmpLastStart = tmpLastStart.AddDays(pushLastWeekStartToFirstDay);
                    if ((pushLastWeekStartToFirstDay * -1) >= 4)
                    {
                        tmpLastStart = tmpLastStart.AddDays(7);
                    }


                    tmpLastYear.FinancialStartDate = tmpLastStart;
                    tmpLastYear.FinancialEndDate = tmpLastEnd;

                    tmpThisYear.FinancialStartDate = tmpThisStart;
                    tmpThisYear.FinancialEndDate = tmpThisEnd;

                    fvm.LastYear = tmpLastYear;
                    fvm.ThisYear = tmpThisYear;

                    return fvm;
                }
            }

            return fvm;
        }

        public static System.Drawing.Color GetItemValue(List<String> list, int index) {
            if (!list.IsNull())
            {
                if (list[index] == "Blank")
                    return Color.FromArgb(64, 64, 64);

                else if (list[index] == "Extended")
                    return Color.FromName("LawnGreen");

                else if (list[index] == "Reduced")
                    return Color.FromName("Teal");

                else if (list[index] == "Remain")
                    return Color.FromName("MediumSpringGreen");
            }
            return Color.White;
        }



        public static string CheckSites(int site)
        {
            try
            {
                if (site > 0)
				{
					return site + " " + CompanyStoreHourReport.CompanyStoreHourReport_Site_s;
				}
				else
				{
					return "-";
				}
            }
            catch
            {
                return "-";
            }
        }

        public static string CheckExpectedIncrease(double expectedIncrease)
        {
            string format = "{0:0.00}";

            try
            {
                if (expectedIncrease != 0)
                {
                    return string.Format(format, expectedIncrease) + "%";
                }
                else
                {
                    return " -";
                }
            }
            catch
            {
                return " -";
            }

        }

        public static string CheckExpectedSaved(double expectedSaved)
        {
            try
            {
                if (expectedSaved > 0)
                {
					return expectedSaved + " " + CompanyStoreHourReport.CompanyStoreHourReport_HourLower;
                }
                else if (expectedSaved == 0)
                {
                    return "-";
                }
                else
                {
					return "-" + expectedSaved + " " + CompanyStoreHourReport.CompanyStoreHourReport_HourLower;
                }
            }
            catch
            {
                return "N/A";
            }
        }
        public static string CheckExtendedHours(double hours)
        {
            string format = "{0:0.00}";

            try
            {
                if (hours > 0)
                {
                    return "+" + string.Format(format, hours) + " " + CompanyStoreHourReport.CompanyStoreHourReport_HourLower;
				}
                else if (hours < 0)
                {
                    return "-" + string.Format(format, Math.Abs(hours)) + " " + CompanyStoreHourReport.CompanyStoreHourReport_HourLower;
				}
                else
                {
                    return "-";
                }
            }
            catch
            {
                return "-";
            }
        }
                

        public static string CheckExpectedSavedh(double expectedSaved)
        {
            string format = "{0:0.00}";

            try
            {
                if (expectedSaved > 0)
                {
                    return "+" + string.Format(format, Math.Abs(expectedSaved)) + " " + CompanyStoreHourReport.CompanyStoreHourReport_HourLower;
				}
                else if (expectedSaved < 0)
                {
                    return "N/A";
                }
                else
                {
                    return "N/A";
                }
            }
            catch
            {
                return "N/A";
            }
        }

        public static System.Drawing.Image GetDiffImage(double salesConversion)
        {
            if (salesConversion > 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
            }
            else if (salesConversion < 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
            }
        }
    }
}